import pandas as pd
import scipy as sp
import networkx as nx
import matplotlib.pyplot as plt
from model import Model
from worlds import neumann, moore, voronoi
from helper import stackplot, lineplot, worldplot, comparison


# Generate worldplots
worldplot(36, 'neumann')
worldplot(36, 'moore')
worldplot(36, 'voronoi')


# Small Population
# generate stackplot for datasets of small agent populations
filenames = ['degrees_max', 'degrees_min', 'structures', 'breaking']
dataindices = [1, 2, 6, 8]
for i, di in enumerate(dataindices):
    d = 'moo' + str(di)
    datanames = [d + '_rumors.csv', d + '_truths.csv', d + '_blanks.csv']
    stackplot(81, 301, datanames, filenames[i])


# Schelling populations
# generate lineplot for datasets of large schelling segregated agent populations
modes = []
percentages = list(range(0, 100))
for p in percentages:
    val = round(p * 952 / 100)
    val = int(val / 2) # half so percentages are correct
    m = (9, 0, val, val, 952 - 2 * val, 10, 10, 100, 0.3)
    modes.append(m)

datanames = []
for m in modes:
    d = 'sch' + str(2 * sum(m[2:3])) + '_rumors.csv'
    datanames.append(d)

# pass to lineplot
# number of agents, cut off index, datanames, filename
lineplot(961, 2000, percentages, datanames, 'schelling')


# Setting: degrees
# images for max degrees
world = moore(81)
model = Model(*world, setting=('degrees', 'max'))
model.run(100, 1, None, None, mechanism='crival', show=True, mode='s')

# images for min degrees
world = moore(81)
model = Model(*world, setting=('degrees', 'min'))
model.run(100, 1, None, None, mechanism='crival', show=True, mode='s')


# Setting: plauwalls
# images for walls without plausibility checking
world = moore(81)
model = Model(*world, setting=('plauwalls', ''))
model.run(100, 1, 1, None, mechanism='plaucheck', show=True, mode='s')

# images for walls with plausibility checking
world = moore(81)
model = Model(*world, setting=('plauwalls', ''))
model.run(100, 1, 0.99, None, mechanism='plaucheck', show=True, mode='s')


# Setting: compwalls
# images for walls without competence checking
world = moore(81)
model = Model(*world, setting=('compwalls', ''))
model.run(100, 1, 1, 0, mechanism='compcheck', show=True, mode='s')

# images for walls with competence checking
world = moore(81)
model = Model(*world, setting=('compwalls', ''))
model.run(100, 1, 1, 0.1, mechanism='compcheck', show=True, mode='s')


# Setting: schelling
# images for walls with competence checking
world = moore(961)
m = (9, 0, 238, 238, 952 - 2 * 238, 10, 10, 100, 0.3) # 50 % plausibles 50 % gullibles
model = Model(*world, setting=('schelling', m))
model.run(100, 0.99, 0.99, 0.1, mechanism='compcheck', show=True, mode='l')


# Comparison of Kendalls tau values for network types
# on all simualtion datasets
comparison()