import concurrent.futures
from helper import collect


# default settings moore
# world, runs, ticks, sre, srp, src, setting, mechanism, filename
params = [['moore', 81, 100, 1000,    1, None, None,  ('degrees', 'max'),    'crival', 'moo1'],
          ['moore', 81, 100, 1000,    1, None, None,  ('degrees', 'min'),    'crival', 'moo2'],
          ['moore', 81, 100, 1000,    1, None, None, ('centrals', 'max'),    'crival', 'moo3'],
          ['moore', 81, 100, 1000,    1, None, None, ('centrals', 'min'),    'crival', 'moo4'],
          ['moore', 81, 100, 1000,    1,    1, None,   ('plauwalls', ''), 'plaucheck', 'moo5'],
          ['moore', 81, 100, 1000,    1, 0.99, None,   ('plauwalls', ''), 'plaucheck', 'moo6'],
          ['moore', 81, 100, 1000,    1,    1,    0,   ('compwalls', ''), 'compcheck', 'moo7'],
          ['moore', 81, 100, 1000,    1,    1,  0.1,   ('compwalls', ''), 'compcheck', 'moo8']]

if __name__ == '__main__':
    with concurrent.futures.ProcessPoolExecutor(max_workers=3) as executor:
        for p in params:
            executor.submit(collect, *p)

# default settings neumann
# world, runs, ticks, sre, srp, src, setting, mechanism, filename
params = [['neumann', 81, 1000, 1000,    1, None, None,  ('degrees', 'max'),    'crival', 'neu1'],
          ['neumann', 81, 1000, 1000,    1, None, None,  ('degrees', 'min'),    'crival', 'neu2'],
          ['neumann', 81, 1000, 1000,    1, None, None, ('centrals', 'max'),    'crival', 'neu3'],
          ['neumann', 81, 1000, 1000,    1, None, None, ('centrals', 'min'),    'crival', 'neu4'],
          ['neumann', 81, 1000, 1000,    1,    1, None,   ('plauwalls', ''), 'plaucheck', 'neu5'],
          ['neumann', 81, 1000, 1000,    1, 0.99, None,   ('plauwalls', ''), 'plaucheck', 'neu6'],
          ['neumann', 81, 1000, 1000,    1,    1,    0,   ('compwalls', ''), 'compcheck', 'neu7'],
          ['neumann', 81, 1000, 1000,    1,    1,  0.1,   ('compwalls', ''), 'compcheck', 'neu8']]

if __name__ == '__main__':
    with concurrent.futures.ProcessPoolExecutor(max_workers=3) as executor:
        for p in params:
            executor.submit(collect, *p)

# default settings voronoi
# world, runs, ticks, sre, srp, src, setting, mechanism, filename
params = [['voronoi', 81, 900, 1000,    1, None, None,  ('degrees', 'max'),    'crival', 'vor1'],
          ['voronoi', 81, 900, 1000,    1, None, None,  ('degrees', 'min'),    'crival', 'vor2'],
          ['voronoi', 81, 900, 1000,    1, None, None, ('centrals', 'max'),    'crival', 'vor3'],
          ['voronoi', 81, 900, 1000,    1, None, None, ('centrals', 'min'),    'crival', 'vor4'],
          ['voronoi', 81, 900, 1000,    1,    1, None,   ('plauwalls', ''), 'plaucheck', 'vor5'],
          ['voronoi', 81, 900, 1000,    1, 0.99, None,   ('plauwalls', ''), 'plaucheck', 'vor6'],
          ['voronoi', 81, 900, 1000,    1,    1,    0,   ('compwalls', ''), 'compcheck', 'vor7'],
          ['voronoi', 81, 900, 1000,    1,    1,  0.1,   ('compwalls', ''), 'compcheck', 'vor8']]

if __name__ == '__main__':
    with concurrent.futures.ProcessPoolExecutor(max_workers=3) as executor:
        for p in params:
            executor.submit(collect, *p)
            
# default settings voronoi
# world, runs, ticks, sre, srp, src, setting, mechanism, filename
params = [['social', 81, 900, 1000,    1, None, None,  ('degrees', 'max'),    'crival', 'soc1'],
          ['social', 81, 900, 1000,    1, None, None,  ('degrees', 'min'),    'crival', 'soc2'],
          ['social', 81, 900, 1000,    1, None, None, ('centrals', 'max'),    'crival', 'soc3'],
          ['social', 81, 900, 1000,    1, None, None, ('centrals', 'min'),    'crival', 'soc4'],
          ['social', 81, 900, 1000,    1,    1, None,   ('plauwalls', ''), 'plaucheck', 'soc5'],
          ['social', 81, 900, 1000,    1, 0.99, None,   ('plauwalls', ''), 'plaucheck', 'soc6'],
          ['social', 81, 900, 1000,    1,    1,    0,   ('compwalls', ''), 'compcheck', 'soc7'],
          ['social', 81, 900, 1000,    1,    1,  0.1,   ('compwalls', ''), 'compcheck', 'soc8']]

if __name__ == '__main__':
    with concurrent.futures.ProcessPoolExecutor(max_workers=3) as executor:
        for p in params:
            executor.submit(collect, *p)

# schelling setting moore
# generate data for schelling segregated agent population
modes = []
percentages = list(range(0, 100))
for p in percentages:
    val = round(p * 952 / 100)
    val = int(val / 2)
    m = (9, 0, val, val, 952 - 2 * val, 10, 10, 100, 0.3)
    modes.append(m)

# world, runs, ticks, sre, srp, src, setting, mechanism, filename
params = []
for m in modes:
    p = ['moore', 961, 20, 2000, 0.99, 0.99, 0.1, ('schelling', m), 'compcheck', 'sch' + str(sum(m[2:4]))]
    params.append(p)

if __name__ == '__main__':
    with concurrent.futures.ProcessPoolExecutor(3) as executor:
        for p in params:
            executor.submit(collect, *p)
            
            
# schelling setting social
# generate data for schelling segregated agent population
modes = []
percentages = list(range(0, 100))
for p in percentages:
    val = round(p * 952 / 100)
    val = int(val / 2)
    m = (9, 0, val, val, 952 - 2 * val, 10, 10, 100, 0.3)
    modes.append(m)

# world, runs, ticks, sre, srp, src, setting, mechanism, filename
params = []
for m in modes:
    p = ['social', 961, 20, 2000, 0.99, 0.99, 0.1, ('schelling', m), 'compcheck', 'sch_soc' + str(sum(m[2:4]))]
    params.append(p)

if __name__ == '__main__':
    with concurrent.futures.ProcessPoolExecutor(3) as executor:
        for p in params:
            executor.submit(collect, *p)