# Program for dynamic evolution of networks in 1-2 dimensions
# each agent is situated in the space and can interact with all others

require(igraph)
require(statnet)

rm(list = ls())

nav <- 20
nsize <- 40
ndim <- 2 # n =  1 or 2 dimensions only; d=1 circular, d=2 => no periodic boundaries
nagents <- nsize^ndim
nlinks <- 4*nagents # for random initial conditions only
neilevel <- 2 # level of neighborhood, only first neighbors, second neighbors, etc. for lattices
nrunpag <- 50
nruns <- nrunpag * nagents  # Number of updates in one run
beta <- 1.0 # Inverse temperature
expodist <- 1 # Distance exponent
weightdegree <- 0.0  # Weight in the energy associated to the degree
jopin <- 20.0 # Relative importance of opinions for network rewiring
surprfac <- 1.00 # Surprise advantage in favor of +1
ikeepcon <- TRUE # Flag for keeping a connected network
ininetsteps <- 0*nagents

#surprlist <- c(1.0, 1.05, 1.1,  1.15, 1.2, 1.25, 1.3, 1.35) # Values of surprise that will be simulated
surprlist <- c(1.0, 1.5, 2.0) # Values of surprise that will be simulated

ncases <- length(surprlist)
ntot <- nruns + ininetsteps

maxinuop <- 2.0
Bolrewire <- FALSE # Introduce network rewiring?
nopinet <- 1 #Number of opinion updates for each network rewiring

#Boolean decisions (check which ones are implemented before running)

Blatti <- TRUE #if true, lattice network, if false, random

#sqrmaxdist <- 2 #square of the maximum distance for a link 

#Histogram variables. Keep the same values for all important runs to allow compatibility in graphics

#surpmax <- max(surprlist)
surpmax <- 2.0
xhistmax <- 1.75 * surpmax * nrunpag
nhistbins <- 50
histlenght <- nhistbins +1
yhistmax <- (10*nagents)/(nhistbins)

cumulhist <- matrix(0, nhistbins, ncases)

propagree <- rep(0,ncases)


# Defining functions



#Calculate the spatial distance between the points
sqdistanciapontos<- function(x1,x2){
  disttemp <- abs(x1-x2)
  if (disttemp <= nagents/2){
    distancia <- disttemp^expodist
  } else {
    distancia <- (nagents - disttemp)^expodist
  }
  distancia
}


#End of functions

#Begining of real code

#Initializing averages

distribudegree <- rep(0,40)
meandistancia <- 0
aglomeracluster <- 0
maioria <- rep(0,ncases)

meandistanciasq <- 0
aglomeraclustersq <- 0
maioriasq <- rep(0,ncases)
stmaioria <- rep(0,ncases)

ntime <- 50
itime <- nruns/ntime
itimconta <- 1

meantimeevol <- rep(0,ntime)
agomeratimeevol <- rep(0,ntime)



for (icases in 1:ncases){
  surprfac <- surprlist[icases]
  
  for (iav in 1:nav) {
    
    if ( Blatti == TRUE) {
      if (ndim ==1) {
        redenet <- make_lattice(dimvector = c(nsize), nei = neilevel, circular = TRUE)
      } else {
        redenet <- make_lattice(dimvector = c(nsize,nsize), nei = neilevel, circular = FALSE)
      }
    } else {
      redenet <- erdos.renyi.game(nagents,nlinks, type = c("gnm"))
    }
    
    #Assign xposis and yposis as needed
    
    if ( ndim == 1) {
      V(redenet)[1:nsize]$xposis <- c(1:nsize)
    } else {
      xposi <- 1
      yposi <- 1
      for (isize1 in 1:nsize)
      {
        for (isize1 in 1: nsize){
          iagdum <- xposi + (yposi-1)*nsize
          V(redenet)[iagdum]$xposis <- xposi
          V(redenet)[iagdum]$yposis <- yposi
          xposi <- xposi +1
          if (xposi == ( nsize+1 )) {xposi <- 1}
        }
        yposi <- yposi +1
        if (yposi == ( nsize+1 )) {yposi <- 1}
        
      }
    }
    
    
    # redenet <- lattice1d(nagents,nlinks)  (not ready, don't use!!!!)
    
    # Initialize opinions
    
    for (iagent in 1:nagents)
    {
      V(redenet)[iagent]$nuop <- runif(1, min=-maxinuop, max=maxinuop)
      V(redenet)[iagent]$bias <- sign(V(redenet)[iagent]$nuop)
      #      V(redenet)[iagent]$bias <- ifelse(sample(0:1,1) == 0, -1, 1)  # 1 favors A, -1 favors B,
    }
    
    
    
    #Update the edges
    
    for (irun in 1:ntot)
    {
      if (irun > ininetsteps){
        for (iops in 1:nopinet)
        {
          iage1 <- as.numeric(sample(V(redenet),1))
          iage2 <- as.numeric(sample(neighbors(redenet,iage1),1))
          iobs <- sign(V(redenet)[iage2]$nuop)
 #         ibias <- V(redenet)[iage1]$bias  #Use for fixed biases
          ibias <- sign(V(redenet)[iage1]$nuop)
          if (ibias < 0){
            if ((iobs)<0){
              V(redenet)[iage1]$nuop <- V(redenet)[iage1]$nuop - surprfac
            }else{
              V(redenet)[iage1]$nuop <- V(redenet)[iage1]$nuop + 1
            }
          }else{
            if ((iobs)<0){
              V(redenet)[iage1]$nuop <- V(redenet)[iage1]$nuop - 1
            }else{
              V(redenet)[iage1]$nuop <- V(redenet)[iage1]$nuop + surprfac
            }
            
          }
        }
      }
      if ((Bolrewire) || (irun <= ininetsteps)  ) {
        
        idumm <- 0
        while (idumm == 0)
        {
          redetemp <- redenet
          iedge1 <- sample(E(redetemp),1)
          iag1 <-  ends(redetemp,iedge1)[[1]]
          iag2 <-  ends(redetemp,iedge1)[[2]]
          redetemp <- delete_edges(redetemp,iedge1)
          if (ikeepcon == TRUE) {
            if (is_connected(redetemp) == TRUE)
            {
              idumm <- 1
            } 
          } else {
            idumm <- 1
          }
        }
        
        idumm <- 0
        while (idumm == 0)
        {
          iag3 <- as.numeric(sample(V(redenet),1))
          iag4 <- as.numeric(sample(V(redenet),1))
          #     iag3 <- as.integer(runif(1, min=0, max=nagents))+1
          #     iag4 <- as.integer(runif(1, min=0, max=nagents))+1
          if ((are.connected(redenet,iag3,iag4) == FALSE) & (iag3 != iag4)  ) {
            redetemp <- redetemp + edges(c(iag3,iag4))
            idumm <-1 
          }
        }
        
        degree1 <- sum(redenet[iag1,])
        degree2 <- sum(redenet[iag2,])
        
        degree3 <- sum(redetemp[iag3,])
        degree4 <- sum(redetemp[iag4,])
        
        #    inimaxdeg <- (max(degree1,degree2))
        #    newmaxdeg <- (max(degree3,degree4))
        #    difmaxdeg <- newmaxdeg - inimaxdeg
        
        
        xposicao1 <- V(redetemp)[iag1]$xposis
        xposicao2 <- V(redetemp)[iag2]$xposis
        xposicao3 <- V(redetemp)[iag3]$xposis
        xposicao4 <- V(redetemp)[iag4]$xposis
        
        
        if (ndim == 1) {
          distx12 <- abs(xposicao1-xposicao2)
          if ( distx12 > nsize/2 ) {distx12 <- nsize - distx12 }
          dist12 <-  distx12
          distx34 <- abs(xposicao3-xposicao4)
          if ( distx34 > nsize/2 ) {distx34 <- nsize - distx34}
          dist34 <-  distx34 
        }
        
        if ( ndim == 2 ){
          distx12 <- abs(xposicao1-xposicao2)
          distx34 <- abs(xposicao3-xposicao4)
          
          yposicao1 <- V(redetemp)[iag1]$yposis
          yposicao2 <- V(redetemp)[iag2]$yposis
          yposicao3 <- V(redetemp)[iag3]$yposis
          yposicao4 <- V(redetemp)[iag4]$yposis
          
          disty12 <- abs(yposicao1-yposicao2)
          dist12 <-  sqrt(distx12 ^2 + disty12^2)
          disty34 <- abs(yposicao3-yposicao4)
          dist34 <-  sqrt(distx34 ^2 + disty34^2)
          
        }
        
        inienerop <- sign(V(redenet)[iag1]$nuop) * sign(V(redenet)[iag2]$nuop)
        newenerop <- sign(V(redenet)[iag3]$nuop) * sign(V(redenet)[iag4]$nuop)
        diffop <- newenerop - inienerop
        
        mudancaenergia <- beta*((dist34^expodist-dist12^expodist) - jopin * diffop)
        #    mudancaenergia <- beta*(-difmaxdeg)
        
        
        # Check for acceptance
        icheck <- 0
        if (mudancaenergia <= 0)
        {
          icheck <- 1
        }
        else
        {
          rteste <- runif(1, min=0, max=1)
          if ( rteste <= exp(-mudancaenergia) )
          {
            icheck <- 1
          }
        }
        if (icheck == 1)
        {
          redenet <- redetemp
        }
        
        if ((irun/itime) == trunc(irun/itime)) {
          meantimeevol[itimconta] <- mean_distance(redenet)
          agomeratimeevol[itimconta] <- transitivity(redenet)
          itimconta <-   itimconta  +1
        }
        
      }
    }
    
    
    imaiodum <- 0
    for (iage in 1:nagents)
    {
      if ( sign(V(redenet)[iage]$nuop) > 0) {
        imaiodum <- imaiodum + 1
      }
#      imaiodum <- imaiodum + sign(V(redenet)[iage]$nuop)
    }
#    addmaio <- ( 0.5 + (0.5 * abs(imaiodum))/nagents)
    addmaio <- imaiodum/nagents
    maioria[icases] <- maioria[icases] + addmaio
    maioriasq[icases] <- maioriasq[icases] + addmaio^2
    
    histbreaks <-  seq(-xhistmax, xhistmax, length.out = histlenght)
    histnow <- hist(V(redenet)$nuop, histbreaks)
#    hist(V(redenet)$nuop, ylim = c(0,yhistmax), histbreaks)
 #   hist(V(redenet)$nuop, xlim = c(-xhistmax,180), ylim = c(0,160), breaks=20)
    for (ibins in 1:nhistbins){
    cumulhist[ibins, icases] <- cumulhist[ibins, icases] + histnow$counts[ibins]
    }
    
    
    isame <- 0
    for (iagesam in 1:nagents){
      if (sign(V(redenet)[iagesam]$nuop) == V(redenet)[iagesam]$bias){
        isame <- isame + 1
      }
    }
    isame <- isame/nagents
    propagree[icases] <- propagree[icases] + isame
    
    
  }
  
  
  distribudegree <- distribudegree/nav
  meandistancia <- meandistancia/nav
  aglomeracluster <- aglomeracluster/nav
  maioria[icases] <- maioria[icases]/nav
  
  meandistanciasq <- meandistanciasq/nav
  aglomeraclustersq <- aglomeraclustersq/nav
  maioriasq[icases] <- maioriasq[icases]/nav
  
  stdmeandistancia <- sqrt( meandistanciasq - meandistancia^2)  
  staglomera <- sqrt(aglomeraclustersq - aglomeracluster^2)
  stmaioria[icases] <- sqrt(maioriasq[icases]-maioria[icases]^2)
  
  for (ibins in 1:nhistbins){
    cumulhist[ibins, icases] <- cumulhist[ibins, icases]/nav
  }
  propagree[icases] <- propagree[icases]/nav

}
for (iagent in 1:nagents)
{
  if (V(redenet)[iagent]$nuop < 0)
  {
#    V(redenet)[iagent]$label.color <- "white"
#    V(redenet)[iagent]$color <- "white"
    redcol <- - V(redenet)[iagent]$nuop/(02.0*nrunpag)
    if ( redcol > 1 ) { redcol <- 1 }
    redcol <- 1-redcol
    V(redenet)[iagent]$color <- (rgb(redcol, .0, .0))
  }
  else
  {
#    V(redenet)[iagent]$label.color <- "black"
#    V(redenet)[iagent]$color <- "black"
    bluecol <- V(redenet)[iagent]$nuop/(02.0*nrunpag)
    if ( bluecol > 1 ) { bluecol <- 1 }
    bluecol <- 1- bluecol
    V(redenet)[iagent]$color <- (rgb(.0, .0, bluecol))
  }
}


plot(histnow$mids[] ,cumulhist[,1],pch=0, "b",col="red",lwd=2)
lines(histnow$mids[] ,cumulhist[,2],pch=0, "b",col="blue",lwd=2)
lines(histnow$mids[] ,cumulhist[,3],pch=0, "b",col="green",lwd=2)

#plot(agomeratimeevol)
#plot(meantimeevol)


#plot(distribudegree)
#gtrans(redenet)

#distg <- geodist(redenet)
#distg$gdist

#hist(V(redenet)$nuop)

