from collections import defaultdict
import random 

from mesa.time import SimultaneousActivation

class SimultaneousDebateActivation(SimultaneousActivation):
    """A scheduler to simulate the simultaneous activation of all the agents.

    """

    def community_proba(self, arg):
            '''
            returns the probability of the community deciding that an argument is acceptable based on their shared beliefs.
            '''
            s = arg.strength
            return self.model.shared_beliefs*s + 1 - self.model.shared_beliefs
        

    def step(self) -> None:
        
        agent_keys = list(self._agents.keys())


        # CHOICE PHASE : for free agents, choosing a GPOV and a node to attack

        for agent_key in agent_keys:
            self._agents[agent_key].choose()

        # STUDY PHASE

        for agent_key in agent_keys:
            self._agents[agent_key].study()

        #PUBLISH PHASE
  
        for agent_key in agent_keys:
            self._agents[agent_key].publish()

        
        # UPDATE PHASE - deciding which arguments to accept
        new_arguments = self.model.new_arguments

        '''
        Community Evaluation. The community as a whole decides whether to discard or keep a new argument, based on the strength of 
        of the argument and on the shared beliefs. 
        '''
        acceptable_arguments = []
        for auth, arg in new_arguments:
            e = random.random()
            if e <= self.community_proba(arg):
               acceptable_arguments += [(auth,arg)]

        '''
        Individual Evaluation. The agent includes a new argument which has been approved by the community only if she 'sees'. 
        This only depends on a probability (which we call p_accept)
        '''
        for agent in self.agents:
            for auth, arg in acceptable_arguments :
                if random.random() <= self.model.p_accept:
                    agent.update([arg])


        self.model.new_arguments = []

            
        self.steps += 1
        self.time += 1
