from model import Debate
from graphs import DebateGraph
import random
import csv
from datetime import datetime

import pandas as pd

import numpy as np

'''
    This file allows the user to choose the parameters to launch simulations.
    We also provide an example loop to generate simulations.  
    '''


def run_debate( number_of_steps,param_dict):

    '''
    This method runs an instance of a debate model with a certain amount of steps and with a dictionary containing
    all the parameters.
    '''
 

    debate_model = Debate(param_dict)
    stats = debate_model.run_model(number_of_steps)

    return debate_model, stats


if __name__ == '__main__':
    

    '''
    Here change the parameters and the loop to generate the model output. 

    PARAMETERS: 

    1. Simulation Parameters
        number_of_steps = the number of steps of each simulation 
        nb_of_repetitions = how many time a simulation with the same parameters will be run. 

    2. Model Parameters
    (these paramters are stored in a dictionnary called param_dict)
        num_agents = total number of agents
        num_issues = number of issues by ResProg
        initial_support = initial support for ResProg 1
        new_arguments = the arguments that are published in the present turn.
        p_see = probability for an agent to see a new argument and include it into its
        research program.
        issue_mean_1 = The strength of research program 1
        issue_mean_2 = The strength of research program 2
        std_attacks = the standard deviation of the distribution for sampling the strength of the attacks.
        bias = the bias each agent has.
        shared_beliefs = the intensity of the shared beliefs
    '''


    # ---- Example 

    number_of_steps = 100
    nb_of_repetitions= 10

    param_dict = dict()
    
    param_dict['num_agents'] = 10
    param_dict['num_issues'] = 5 
    param_dict['p_accept'] = 0.5
    param_dict['std_attacks'] = 0.2
    param_dict['bias'] = 0
    param_dict['shared_beliefs'] = 0
    param_dict['initial_support'] = 5
    param_dict['issue_mean_1'] = 0.7
    param_dict['issue_mean_2'] = 0.3


    '''
    The following lines provide a way to store the results. 
    '''
    
    # storing the simulations results for the agents and the arguments
    game_stats = pd.DataFrame()
    arg_stats = pd.DataFrame()

    dt_string = datetime.now().strftime("%d_%m_%Y %H_%M_%S")                
    name = 'Results/bias_' + str(param_dict['bias']) + '_sb_' + str(param_dict['shared_beliefs']) + '_support_'+ str(param_dict['initial_support'])+ '_results_' + dt_string + '.xlsx'
    writer = pd.ExcelWriter(name, engine='xlsxwriter')

    # looping and generating simulations

    debate_count = 0
    for r in range(nb_of_repetitions):
                    
            # ---- uncomment to generate simulations with reserch programs of random strengths
            # param_dict['issue_mean_1'] = random.random()
            # param_dict['issue_mean_2'] = random.random()

            debate_model, stats = run_debate(number_of_steps, param_dict)

            stats_df = pd.DataFrame.from_records(stats)
            stats_df['Debate'] = debate_count
            game_stats = pd.concat([game_stats, stats_df], sort=False).fillna(0)

            # Saving the stats of arguments - comment out to save space : 

            args_df = pd.DataFrame.from_records(debate_model.all_arg_stats)
            args_df['Debate'] = debate_count
            args_df['Bias'] = param_dict['bias'] 
            arg_stats = pd.concat([arg_stats, args_df], sort=False).fillna(0)

            del debate_model, stats_df, stats, args_df

            debate_count += 1
            print(debate_count)
    
    game_stats.to_excel(writer, sheet_name='Model')
    arg_stats.to_excel(writer, sheet_name='Arguments')
    writer.close()

    print()
    print()
    print()
    print("================== REPETITIONS OVER==========================")
    print()
    print()
    print()

   


