from graphs import DebateGraph, WeightedDebateGraph
import random
from argument import Argument, WeightedArgument

'''
The present class allows to instatiate the view of an agent on a research program. 
In addition, it also provides a list of methods useful to analyse such views.
A view is composed of a specific number of argumentation trees (CAATs), where each root represents a central argument.

'''


class GPOV():
    # a groupe of argumentation graphs corresponding to different Theses. 

    def __init__(self, name, issue_ids) -> None:
        self.name = name
        self.graphs = [DebateGraph(self, issue_n) for issue_n in issue_ids]
    
    def get_name(self):
        return self.name

    def get_score(self):
        # returns the score : the number of thesis of the gpov which are acceptable
        score = 0
        for graph in self.graphs:
             if graph.issue_acceptability:
                 score += 1
        return score


    def choose_random_node(self):
        all_nodes = [n for graph in self.graphs for n in graph.nodes]
        return random.choice(all_nodes)

    def find_id(self, arg_id):
        #return an argument based on its id
        for graph in self.graphs:
            for node in graph.nodes:
                if str(node.id) == str(arg_id):
                    return node

    def add_argument(self, arg_id, tree_id, attacked_arg_id):
        # arg = Argument(arg_id, strenght)
        attacked_arg = self.find_id(attacked_arg_id)
        if attacked_arg is not None:
            #print(attacked_arg)
            for graph in self.graphs:
                if str(graph.get_name()) == str(tree_id):
                    #print("found tree :", graph.get_name())
                    arg = Argument(arg_id, attacked_arg, graph)
                    graph.add_edge(arg, attacked_arg)

                    #changing the acceptability value of the issue:
                    o = graph.get_oddity(arg)
                    if o ==0 and graph.issue_acceptability: #attack arg
                        graph.issue_acceptability = False
                    if o==1 and not graph.issue_acceptability:
                        graph.issue_acceptability = graph.is_issue_acceptable()
                
    def all_arguments(self):
        all_args = []
        for graph in self.graphs:
            all_args += [node for node in graph.nodes]
        return all_args

    def visualize(self):
        #print("GPOV ", self.name)
        for graph in self.graphs:
            graph.view_graph()
        #print()

    def get_issue_ids(self):
        ids = []
        for graph in self.graphs:
            ids += [graph.get_issue().id]
        return ids

    def find_tree_by_id(self, tree_id):
    #returns a tree based on its issue id
        for graph in self.graphs:
                if graph.get_name() == tree_id:
                    return graph


class WeightedGPOV(GPOV):
    # a groupe of argumentation graphs corresponding to theses with strength.

    def __init__(self, name, issue_strengths) -> None:
        self.name = name
        self.graphs = [WeightedDebateGraph(self,issue_s) for issue_s in  issue_strengths]
        self.strength = sum(issue_strengths)
    
    def publish_argument(self, arg):
        for graph in self.graphs:
            if graph.get_name() == arg.tree.get_name():
                graph.add_edge(arg, arg.attacked_arg)

                #changing the acceptability value of the issue:
                o = graph.get_oddity(arg)
                if o ==0 and graph.issue_acceptability: #attack arg
                    graph.issue_acceptability = False
                if o==1 and not graph.issue_acceptability:
                    graph.issue_acceptability = graph.is_issue_acceptable()
                    





    
