import itertools


class Argument():

    def __init__(self, id, attacked_arg, tree) -> None:
        # an argument is characterized by a unique numerical ID, a strength, the argument it attacks, and the tree it is part of
        self.id = id
        self.attacked_arg = attacked_arg  
        self.tree = tree
    
    def __str__(self) -> str:
        return "Argument " + str(self.id)
    
    def is_against(self, agent):
        # Returns whether an argument is against an agent's preferred gpov
        preferred = agent.preferred_GPOV
        inside = self.tree.get_gpov_name()
        pro = self.tree.get_oddity(self)
        if str(preferred) == str(inside):
            if pro == 1:
                return False
            else:
                return True
        else:
            if pro == 1:
                return True
            else:
                return False






class WeightedArgument(Argument):

    id_iter = itertools.count()

    def __init__(self, strength, attacked_arg, tree) -> None:
        # an argument is characterized by a unique numerical ID, a strength, the argument it attacks, and the tree it is part of
        self.id = next(WeightedArgument.id_iter)
        self.strength = strength
        self.attacked_arg = attacked_arg
        self.tree = tree
    
    def __str__(self) -> str:
        return "Argument " + str(self.id) + " S: " + str(self.strength)
    
    