//-----------------------------------------------------------------------------------------------
// Modified Laver's model
//-----------------------------------------------------------------------------------------------
#include<iostream>
#include<iomanip>
#include<fstream>
#include<math.h>
#include<numeric>
#include<algorithm>
#include<random>
#include<vector>
#include<string>
#include<direct.h>
using namespace std;

#define NUM_REC 6

//class for random numbers 
class RANDOM {
	
	public:
		RANDOM::RANDOM() : rand(random_device()()) {} // Seed the mt19937.

		double runif(double lower, double upper){  //uniform distribution (real)
			uniform_real_distribution<double> dis(lower, upper);
			double random = dis(rand);
			return random;
		}

		int rintunif(int lower, int upper){        //uniform distribution (int)
			uniform_int_distribution<int> dis(lower, upper);
			int random = dis(rand);
			return random;
		}
		
	private:
		mt19937 rand;
};

typedef struct {

	int N;            // # agents
	int k;            // # neighbors
	double p;         // parameter: SW networks
	double x_media;   // position of mass media (-x_media & x_media)
	double p_media;   // probability interaction with mass media
	double delta;     // unit move
	double mu;        // persuasion effect
	double x_start;   // upper bound of initial opinion
	
	int len_relax;
	int len_record;
	int thin;
	int len_MCS;
	string filename;
	int rec_last;
	
}PARAM;

typedef struct {
	double opin;        // opinion
	double media;       // media's opinion
	vector<int> neig;   // neighbors
}AGENT;

// functions
void set_param (PARAM &fP, int N, int k, double p, double x_media, double p_media, double delta, double mu, double x_start,
                int len_relax, int len_record, int thin, string filename, int rec_last);
void process (PARAM &fP, int rep);
void SW_net (PARAM &fP, vector<AGENT> &fAGENT);
void assign_media (PARAM &fP, vector<AGENT> &fAGENT);
void write_file (PARAM &fP, long double o_sd, int mcs, int rep, int n_rec);
void write_file_last (PARAM &fP, vector<AGENT> &fAGENT, int rep);

// Below is the main process
RANDOM rt;
int main (void) {
	
	PARAM par;
	
	//_______(par, N, k, p, x_media, p_media, delta, mu, x_start, len_relax, len_record, thin, filename, rec_last)
	set_param(par, 1000, 4, 0.01, 2.0, 0.001, 0.1, 0.01, 3.0, 340000, 160000, 200, "test_output.csv", 1);
	for (int rep = 0; rep < 5; rep++) process(par, rep);
				
	return 0;
}

//---------------------------------------------------------------------------------------------
// set_param
//   setting the parameters of the simulation
//---------------------------------------------------------------------------------------------
void set_param (PARAM &fP, int N, int k, double p, double x_media, double p_media, double delta, double mu, double x_start,
                int len_relax, int len_record, int thin, string filename, int rec_last) {
	
	fP.N           = N;
	fP.k           = k;
	fP.p           = p;
	fP.x_media     = x_media;
	fP.p_media     = p_media;
	fP.delta       = delta;
	fP.mu          = mu;
	fP.x_start     = x_start;
	fP.len_relax   = len_relax;
	fP.len_record  = len_record;
	fP.len_MCS     = len_relax + len_record;
	fP.thin        = thin;
	fP.filename    = "laver_SW_" + filename;
	fP.rec_last    = rec_last;
}

//---------------------------------------------------------------------------------------------
// process
//   process of one simulation run
//---------------------------------------------------------------------------------------------
void process (PARAM &fP, int rep) {
	
	// agent
	vector<AGENT> agent(fP.N);
	int focal = -1, role = -1;
	double r_opin;
		
	// record standard deviation
	long double o_sd = 0;
	double o_sum = 0, o_sum2 = 0;
	
	// record related values
	int when_to_rec = fP.len_relax - 1;
	int n_rec       = 0;
	// convergence?
	int when_to_reset = fP.len_relax + fP.len_record / NUM_REC - 1;
	
	// agent & networks
	for (int i = 0; i < fP.N; i++) 
		agent[i].opin = rt.runif(-fP.x_start, fP.x_start);
	SW_net(fP, agent);
	assign_media(fP, agent);
	
	// loop
	for (int mcs = 0; mcs < fP.len_MCS; mcs++) {
		for (int time = 0; time < fP.N; time++) {
			
			// focal agent AND {role agent OR role media}
			focal = rt.rintunif(0, fP.N-1);
			if (rt.runif(0, 1) < fP.p_media) {
				r_opin = agent[focal].media;
			} else {
				role   = agent[focal].neig[rt.rintunif(0, agent[focal].neig.size()-1)];
				r_opin = agent[role].opin;
			}
			
			// updating (persuasion)			
			agent[focal].opin += fP.mu * (r_opin - agent[focal].opin);
			// updating (error)	
			rt.runif(0, 1) < 0.5 ? agent[focal].opin += fP.delta : agent[focal].opin -= fP.delta;
		}
		
		// save data
		if (mcs == when_to_rec) {
			// reset
			o_sum  = 0;
			o_sum2 = 0;
			// record
			for (int agt = 0; agt < fP.N; agt++) {
				o_sum  += agent[agt].opin;
				o_sum2 += pow(agent[agt].opin, 2.0);
			}
			o_sd += sqrt(o_sum2 / fP.N - pow(o_sum / fP.N, 2.0));
			when_to_rec += fP.thin;
			++n_rec;
		}
		
		// write file
		if (mcs == when_to_reset) {
			// write file
			write_file (fP, o_sd, mcs, rep, n_rec);
			// reset 
			o_sd  = 0;
			when_to_reset += fP.len_record / NUM_REC;
			n_rec = 0;
		}
	}
	
	cout << fP.N << "," << fP.k << "," << fP.p << "," << fP.x_media << "," << fP.p_media << "," << fP.delta << "," << fP.mu << "," << fP.x_start << "," 
	     << fP.len_relax << "," << fP.len_record << "," << fP.thin << "," << rep << '\n';
		
	if (fP.rec_last)
		write_file_last (fP, agent, rep);
}

//---------------------------------------------------------------------------------------------
// Small-world networks
//---------------------------------------------------------------------------------------------
void SW_net (PARAM &fP, vector<AGENT> &fAGENT) {
	
	int k_half = fP.k / 2;
	int a0, a1;
	int n_add  = fP.N * fP.k * fP.p / 2;
	int n_complete = 0;
	int i_pos;
	
	// expanded cycle
	for (int agt = 0; agt < fP.N; agt++) {
		fAGENT[agt].neig.resize(fP.k);
		// k_half nearest neighbors
		for (int i = 1; i <= k_half; i++) {
			i_pos = i - 1;
			agt+i < fP.N ? fAGENT[agt].neig[2*i_pos]   = agt + i : fAGENT[agt].neig[2*i_pos]   = agt + i - fP.N; 
			agt-i >= 0   ? fAGENT[agt].neig[2*i_pos+1] = agt - i : fAGENT[agt].neig[2*i_pos+1] = agt - i + fP.N;
		}
	}
	// add random links
	while (n_complete < n_add) {
		a0 = rt.rintunif(0, fP.N-1);
		do {a1 = rt.rintunif(0, fP.N-1);} while (a0 == a1);   // avoid loop
		
		for (int i = 0; i < fAGENT[a0].neig.size(); i++) {    // avoid duplicate
			if (fAGENT[a0].neig[i] == a1)
				break;
			if (i == fAGENT[a0].neig.size()-1) {
				fAGENT[a0].neig.push_back(a1);
				fAGENT[a1].neig.push_back(a0);
				++n_complete;
			}
		}
	}
}

void assign_media (PARAM &fP, vector<AGENT> &fAGENT) {
	
	int half_N = fP.N / 2;
	int select;
	vector<int> id(fP.N);
	
	for (int i = 0; i < fP.N; i++) {
		id[i] = i;
		fAGENT[i].media = fP.x_media;
	}
	for (int i = 0; i < half_N; i++) {    // choose half of agents
		select = rt.rintunif(i, fP.N-1);
		fAGENT[id[select]].media = -fP.x_media;
		id[select] = id[i];               // Because id[select]'s information is stored in fAGENT, swap is not required
	}
}

//---------------------------------------------------------------------------------------------
// write_file
//---------------------------------------------------------------------------------------------
void write_file (PARAM &fP, long double o_sd, int mcs, int rep, int n_rec) {
	
	ofstream fout(fP.filename, ios::app);
	fout << fP.N << "," << fP.k << "," << fP.p << "," << fP.x_media << "," << fP.p_media << "," << fP.delta << "," << fP.mu << "," << fP.x_start << ","  
	     << fP.len_relax << "," << fP.len_record << "," << fP.thin << "," << mcs << "," << rep << "," << o_sd / n_rec << '\n';
}

void write_file_last (PARAM &fP, vector<AGENT> &fAGENT, int rep) {
	
	ofstream fout("opin_" + fP.filename, ios::app);
	fout << fP.N << "," << fP.k << "," << fP.p << "," << fP.x_media << "," << fP.p_media << "," << fP.delta << "," << fP.mu << "," << fP.x_start << ","
	     << fP.len_relax << "," << fP.len_record << "," << fP.thin << "," << rep << ",";
	
	for (int i = 0; i < fP.N; i++)
		fout << fAGENT[i].opin << ",";
	fout << '\n';
}
