# Program by Alireza Mansouri
# This program generates diagrams from output of the agent-based model discussed in a manuscript under review by JASSS
# The manuscript title is:
# Phase Transition in the Social Impact Model of Opinion Formation in Scale-Free Networks: The Social Power Effect
#
# Input of this program is file(s) generated by 'SocialImpact-7-NoThresh'.
# The folder 'LastRun' is defined to contain the input file(s) and the output diagrams are located in the same folder.

from diag_lib_Second_Revision import get_value, get_Hi_values, plot_mean_beta_as_x, plot_mean_hi_as_x, aggregate_files
import numpy as np

np.random.seed(12345678)
max_str = '1000'  # number of agents
path_name = 'Last_Run/'

file_name_list = []
file_name_list.append('Ag_1000-MaxStep_' + max_str + '-uniform-Rnd_30-Hi_0_2000_200-beta_0_1_10.pkl')
file_name_list.append('Ag_1000-MaxStep_' + max_str + '-uniform-Rnd_30-Hi_0_2000_200-beta_10_11_10.pkl')
file_name_list.append('Ag_1000-MaxStep_' + max_str + '-uniform-Rnd_30-Hi_0_2000_200-beta_20_21_10.pkl')
file_name_list.append('Ag_1000-MaxStep_' + max_str + '-uniform-Rnd_30-Hi_0_2000_200-beta_30_31_10.pkl')
file_name_list.append('Ag_1000-MaxStep_' + max_str + '-uniform-Rnd_30-Hi_0_2000_200-beta_40_41_10.pkl')
file_name_list.append('Ag_1000-MaxStep_' + max_str + '-uniform-Rnd_30-Hi_0_2000_200-beta_50_51_10.pkl')

file_name = file_name_list[0]

ag_num = get_value('Ag', file_name)
hi_min, hi_max, hi_step = get_Hi_values(file_name)
max_step = get_value('MaxStep', file_name)
rand_seed = get_value('Rnd', file_name)
print("Uniform: ag_num:%i, hi_min:%i, hi_max:%i, hi_step:%i" % (ag_num, hi_min, hi_max, hi_step))

r_data = aggregate_files(path_name, file_name_list)  # in case the input is segmented in different files

prefix = "Uni"
plot_mean_beta_as_x(path_name, r_data, ag_num, max_step, prefix, rand_seed)
plot_mean_hi_as_x(path_name, r_data, ag_num, prefix, rand_seed)

#  #########################################

file_name_list = []
file_name_list.append('Ag_1000-MaxStep_' + max_str + '-deg_ratio-Rnd_30-Hi_0_2000_200-beta_0_1_10.pkl')
file_name_list.append('Ag_1000-MaxStep_' + max_str + '-deg_ratio-Rnd_30-Hi_0_2000_200-beta_10_11_10.pkl')
file_name_list.append('Ag_1000-MaxStep_' + max_str + '-deg_ratio-Rnd_30-Hi_0_2000_200-beta_20_21_10.pkl')
file_name_list.append('Ag_1000-MaxStep_' + max_str + '-deg_ratio-Rnd_30-Hi_0_2000_200-beta_30_31_10.pkl')
file_name_list.append('Ag_1000-MaxStep_' + max_str + '-deg_ratio-Rnd_30-Hi_0_2000_200-beta_40_41_10.pkl')
file_name_list.append('Ag_1000-MaxStep_' + max_str + '-deg_ratio-Rnd_30-Hi_0_2000_200-beta_50_51_10.pkl')

file_name = file_name_list[0]

ag_num = get_value('Ag', file_name)
hi_min, hi_max, hi_step = get_Hi_values(file_name)
max_step = get_value('MaxStep', file_name)
rand_seed = get_value('Rnd', file_name)
print("Node_Centrality, ag_num:%i, hi_min:%i, hi_max:%i, hi_step:%i" % (ag_num, hi_min, hi_max, hi_step))

r_data = aggregate_files(path_name, file_name_list)  # in case the input is segmented in different files

prefix = "ScP"
plot_mean_beta_as_x(path_name, r_data, ag_num, max_step, prefix, rand_seed)
plot_mean_hi_as_x(path_name, r_data, ag_num, prefix, rand_seed)
