clear all;
%%% FINAL VERSION: 16 JANUARY 2021 %%%

%%% FIGURE 1 - START %%%
%Fig 1: Polarization same sign, changing opinion space
%C is chosen as a 1.2-equal attentiveness matrix, with c11 + c22 = 1.5 + 1
%> 2 * 1.2 such that in a 2-agent population the agents would polarize
%according to Theorem 6.1.
C = [1.5 -0.3; 0.2 1];

%Choose two groups with sizes m1 and m2
m1 = 10;
m2 = 90;

%Neg is a variable that says entries are uniformly picked between [-neg, 1-neg]
neg = 0.2;

%Pick entries of P11 from a uniform distribution between [-neg, 1-neg]
P11 = (rand(m1,m1)-neg)*2;

%Create a diagonal matrix that has at each entry a factor that normalizes
%the corresponding row to 1
P11_norm = inv(diag(P11 * ones(m1,1)));

%Adjust P11 such that P11 is a 1-equal attentiveness matrix
P11 = P11_norm * P11;

%Repeat the steps for P22
%Pick entries of P11 from a uniform distribution between [-neg, 1-neg]
P22 = (rand(m2,m2)-neg)*2;
P22_norm = inv(diag(P22 * ones(m2,1)));
P22 = P22_norm * P22;

%Repeat the steps for P21
P21 = (rand(m2,m1)-neg)*2;
P21_norm = inv(diag(P21 * ones(m1,1)));
P21 = P21_norm * P21;

%Choose P12 such that each agent of subpopulation 1 listens identically to
%the agents in subpopulation 2 (corresponding to the condition of theorem
%6.7)

%Choose a random vector between [-neg, 1-neg]
P12_vec = (rand(1,m2)-neg) *2;

%Normalize the vector such that its sums up to 1
P12_norm = P12_vec / (P12_vec * ones(m2,1));

%Construct P12 where each column equals P12_norm
P12 = ones(m1,1) * P12_norm;

%Construct matrix A
A = [C(1,1)*P11 C(1,2)*P12; C(2,1)*P21 C(2,2)*P22]; 

%Store the number of agents as N
N = size(A,1);

%Choose opinions between [-0.5,0.5]
x0 = rand(N,1)-0.5;

%save/load matrix A
load('ChangingOpinionSpace_A','A')
load('ChangingOpinionSpace_x0','x0')

%Store the number of agents as N (relevant if the code is ran after 'load'
N = size(A,1);

%Iteration steps
steps = 15;

%Initiate a matrix of 0s to store the development of relative opinions in
vector = zeros(N,steps);
%Initiate a matrix of 0s to store the development of absolute opinions in
vector_raw = zeros(N,steps);

%Calculation of absolute and relative opinions with the chosen A and x0
for i = 1:1:steps
  if i == 1
    x = x0;
  else
    x = A * x;
  end
  vector_raw(:,i) = x;
  %normalize such that the aggregate of the absolute entries of the vector equals
  %N
  vector(:,i) = x / (ones(1,N) * abs(x)) * N;
end

%Plot absolute opinions
figure
plot(1:1:steps,vector_raw(:,:),'-')
hold on
xlabel('Time','FontSize',15)
ylabel('Absolute opinion','FontSize',15)
set(gca,'FontSize',19)
x0=10;
y0=10;
width=500;
height=400;
set(gcf,'position',[x0,y0,width,height])
%give the figure the name f in preperation for export
f = gcf
%export with a resolution of 300DPI
exportgraphics(f,'ChangingOpinionSpaceAbs300.png','Resolution',300)
hold off

%Plot relative opinions
figure
plot(1:1:steps,vector(:,:),'-')
hold on
xlabel('Time','FontSize',15)
ylabel('Relative opinion','FontSize',15)
set(gca,'FontSize',19)
x0=10;
y0=10;
width=500;
height=400;
set(gcf,'position',[x0,y0,width,height])
%give the figure the name f in preperation for export
f = gcf
%export with a resolution of 300DPI
exportgraphics(f,'ChangingOpinionSpaceRel300.png','Resolution',300)
hold off

%%% FIGURE 1 - END %%%

clear all;

%%% FIGURE 2 TO 4 - START %%%
%In order to produce the desired figure, run the corresponding A, x0, leg1
%and leg2 (leg1 and leg2 are the input for the legenda)

%Fig 2: Consensus as asymptotic behavior as a result of equal attentiveness
%with a stubborn and open-minded agent
clear all;
A = [1.01 -0.01; 0.1 0.9];
x0 = [-0.5; 1.5];
leg1 = 'Stubborn agent 1';
leg2 = 'Open-minded agent 2';
%Export with a resolution of ExportDPI
ExportDPI = 300;
%Export with name ExportName
ExportName = 'ConsensusStubOpen300.png';

%Fig3a: Polarization as asymptotic behavior as a result of unequal
%attentiveness with two open-minded agents
clear all;
A = [0.99 0.01; 0.2 0.9];
x0 = [1.1; 0.9];
leg1 = 'Open-minded agent 1';
leg2 = 'Open-minded agent 2';
ExportDPI = 300;
ExportName = 'PolOpenOpenUnequalAtt300.png';

%Fig3b: Polarization as asymptotic behavior as a result of equal attentiveness with an open-minded and stubborn agent
clear all;
A = [0.9 0.1; -0.2 1.2];
x0 = [1.1; 0.9];
leg1 = 'Open-minded agent 1';
leg2 = 'Stubborn agent 2';
ExportDPI = 300;
ExportName = 'PolOpenStubEqualAtt300.png';

%Fig3c: Polarization as asymptotic behavior as a result of equal attentiveness with two stubborn agents
clear all;
A = [1.05 -0.05; -0.2 1.2];
x0 = [1.1; 0.9];
leg1 = 'Stubborn agent 1';
leg2 = 'Stubborn agent 2';
ExportDPI = 300;
ExportName = 'PolStubStubEqualAtt300.png';

%Fig4a: Periodicity as asymptotic behavior as a result of 'passing around' opinions
clear all;
A = [0 1; 1 0];
x0 = [-1.5; -0.5];
leg1 = 'Open-minded agent 1';
leg2 = 'Open-minded agent 2';
ExportDPI = 300;
ExportName = 'PerOpenOpenPassingAround300.png';

%Fig4b: Periodicity as asymptotic behavior as a result of a whimsical and
%open-minded agent in an equal attentiveness setting
clear all;
A = [-1 2; 0.1 0.9];
x0 = [1.1; 0.9];
leg1 = 'Whimsical agent 1';
leg2 = 'Open-minded agent 2';
ExportDPI = 300;
ExportName = 'PerWhimOpenEqualAttent300.png';

%fig4c: Periodicity as asymptotic behavior as a result of a stubborn and
%open-minded agent in an unequal attentiveness setting
clear all;
A = [0.5 0.5; -0.1 0.5];
x0 = [1.1; 0.9];
leg1 = 'Open-minded agent 1';
leg2 = 'Stubborn agent 2';
ExportDPI = 300;
ExportName = 'PerOpenStubbornUnEqualAttent300.png';

%Iteration steps
steps = 50;

%Initiate a matrix of 0s to store the development of relative opinions in
vector = zeros(2,steps);

%Calculation of absolute and relative opinions with the chosen A and x0
for i = 1:1:steps
  if i == 1
    x = x0;
  else
    x = A * x;
  end
  %normalize such that the aggregate of the absolute entries of the vector equals
  %2
  x = x / (ones(1,2) * abs(x)) * 2; 
  vector(:,i) = x;
end

figure
plot(1:1:steps,vector(1,:),'-')
hold on
plot(1:1:steps,vector(2,:),'--')
xlabel('Time','FontSize',15)
ylabel('Relative opinion','FontSize',15)
set(gca,'FontSize',19)
x0=10;
y0=10;
width=500;
height=400;
set(gcf,'position',[x0,y0,width,height])
legend(leg1,leg2)
ylim([-2 2])
%give the figure the name f in preperation for export
f = gcf
%export with a resolution of ExportDPI and name ExportName
exportgraphics(f,ExportName,'Resolution',ExportDPI)
hold off