clear all;

%%% FINAL VERSION: 16 JANUARY 2021 %%%
%%% TO RUN THIS CODE ONE SHOULD HAVE ADDED THE FILE HYPERSPHERE.M TO ITS
%%% MATLAB FOLDER. HYPERSPHERE.M IS CODE CREATED BY Gianluca Dorini (2021). 
%%% REFERENCE: Gianluca Dorini (2021). hypersphere (https://www.mathworks.com/matlabcentral/fileexchange/5397-hypersphere), MATLAB Central File Exchange. Retrieved January 2, 2021.

%Let agents 1 and 2 slowly move to a consensus as a stand-alone
%subpopulation
P11 = [0.99 0.01; 0.02 0.98];
P12 = [1; 1];
P21 = [1 1];
P22 = [1];

%Let the second subpopulation existing of agent 3 be repulsive towards the
%first subpopulation. C as a stand-alone system would produce periodic
%behavior by Theorem 6.1 since (1 - 1)^2 < -4 * 0.1 * -0.2
C = [1 0.1; -0.2 1];

%Create matrix A
A = [C(1,1)*P11 C(1,2)*P12; C(2,1)*P21 C(2,2)*P22]; 

%Save the size of A
N = size(A,1);

%Define x0
x0 = [-0.4643; 0.3491; 0.4340];

%Choose the amount of iteration steps
steps = 150;

%Initiate a matrix of 0s to store the development of relative opinions in
vector = zeros(N,steps);
%Initiate a matrix of 0s to store the development of absolute opinions in
vector2 = zeros(N,steps);

%Calculation of absolute and relative opinions with the chosen A and x0
for i = 1:1:steps
  if i == 1
    x = x0;
  else
    x = A * x;
  end
  %normalize such that the aggregate of the absolute entries of the vector equals
  %2
  vector(:,i) = x / (norm(x) * 2);
  vector2(:,i) = x;
end

plot(1:1:steps,vector(:,:),'-o')
legend('Follower','Pioneer')

%Create a 3D Sphere with 3000 dots and radius 1/2
N = 3000;
X = 2*pi*rand(2,N);
r = .5;
Y = HyperSphere([X],r);

%Plot the relative opinions on the 3D Sphere
figure
plot3(Y(1,:),Y(2,:),Y(3,:),'r.')
axis equal
hold on
plot3(vector(3,:),vector(1,:),vector(2,:),'-o','Color','k', 'MarkerSize',5, 'LineWidth',2)
plot3(vector(3,1),vector(1,1),vector(2,1),'s','MarkerFaceColor','b','MarkerEdgeColor','b','MarkerSize',20,'LineWidth',12)
plot3(vector(3,150),vector(1,150),vector(2,150),'d','MarkerFaceColor','g','MarkerEdgeColor','g','MarkerSize',20,'LineWidth',12)
xlabel('Relative opinion Agent 1')
ylabel('Relative opinion Agent 2')
zlabel('Relative opinion Agent 3')
hold off
%give the figure the name f in preperation for export
f = gcf
%export with a resolution of 300DPI
exportgraphics(f,'3DSphereRelativeOpinion.png','Resolution',300)

%Plot absolute opinions
figure
plot3(vector2(3,:),vector2(1,:),vector2(2,:),'-o','Color','k', 'MarkerSize',5, 'LineWidth',2)
axis equal
hold on 
plot3(vector2(3,1),vector2(1,1),vector2(2,1),'s','MarkerFaceColor','b','MarkerEdgeColor','b','MarkerSize',20,'LineWidth',12)
plot3(vector2(3,150),vector2(1,150),vector2(2,150),'d','MarkerFaceColor','g','MarkerEdgeColor','g','MarkerSize',20,'LineWidth',12)

xlabel('Opinion Agent 1')
ylabel('Opinion Agent 2')
zlabel('Opinion Agent 3')
hold off
%give the figure the name f in preperation for export
f = gcf
%export with a resolution of 300DPI
exportgraphics(f,'3DSpiralAbsoluteOpinion.png','Resolution',300) 