extensions [vid]
globals [

   actionlist conditionlist  resource willingess-to-consume consumed-resource institutionlist selectedinstitution average-energy average-resource rule-compliance av-rule-compliance institution-time institution-time-list av-institution-time fine monitoring-intensity-percentage av-monitoring-percentage av-fine monitoring-cost start-record-time resource-energy-ratio total-fine lastinstitutionchangetime cheating-propension _recording-save-file-name

   selectedAction
  selectedCondition
  external-shock
  institution-changed-time
  InstitutionalEmergenceInterval
  InstitutionalEmergenceStart

  shock-time ; the exact time where the shock has happened (calculated in the model, not given)
  Shock-interval
  resource-loss-percentage

  social-shock ; taxation introduced to agents
  social-shock-time ; when is this taxation introduced?
  taxation-amount

  agentStatusEndThreshold

]

turtles-own [
  energy
  selected-action
  selected-condition
  own-idea-fine
  own-idea-monitoring-intensity
  previous-tick-energy
  cheated ; this is to show whether the agent has cheated in this round for possible fine
  cheating-profitable ; boolean showing the outcome of the utility calculation
]
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;setup functions;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to setup
  ca
  no-display
  set-default-shape turtles "circle"
  parameter-setup
  set start-record-time 1000
  set resource K
  set institutionList [] ; set of possible institutions according to the frequency of action-conditions performed by agents
  set selectedInstitution ["" ""]
   set institution-time-list []
    ifelse resource-type = "fishery" [set resource-energy-ratio 1][set resource-energy-ratio 0.1]
  make-actionList
  make-conditionList
  create-agents

  set rule-compliance 1
  set cheating-propension 0 ; keeps track of the percentage of agents who are cheating in the run
  reset-ticks

end

; random parameter setup
to parameter-setup
  set threshold-institutional-change 0.5 + random-float 0.25
  set InstitutionalEmergenceInterval 12
  set institutionalEmergenceStart 500 + random 500
  ;set threshold-institutional-change 0.75
  set social-influence 0.9 + random-float 0.1

  set individual-cheating-propension 0.1 + random-float 0.25
  set K 10000 + random 10000
  set r 0.25 + random-float 0.1
  set number-of-links 1 + random 4
  set innovationRate 0.01 + random-float 0.19
  set monitoring-cost-weight 50 + random 10
  set number-of-agents  100
  set network  "random"
  set display-network? false

  set Institution? true
  set max-fine 20
  set max-monitoring-intensity-percentage 100
  set number-of-links 4
  set rewire-prop 0.1
  set resource-type "fishery"
  set energy-consumption 1;

  ;for resource shock
  set Shock-interval 1000 + random 1000
  set external-shock 0 ; if this run has resource shock, set external-shock 1
  set resource-loss-percentage 20 + random 70

  ;for social shock i.e. taxation
  set social-shock 1 ; if this run has social shock, set social-shock 1
  set social-shock-time 4000 + random 500; this is when the shock is introduced
  set taxation-amount 5 + random 5;

  set agentStatusEndThreshold 0.9 + random 0.10; the percentage of agents who should have negative energy for the simulation to stop


end


to make-actionList
  set actionList [" eat -5"] ; negative value representing a harmful choice
  let i n-values 10 [ ?1 -> ?1 * 2 ] ; positive values to be included in the list
  foreach i [ ?1 ->
    set actionList lput (word " eat " ?1) actionList
  ]
end

to make-conditionList
  set conditionList [" (ticks mod 3) = 0  "  " (ticks mod 2) = 0 " " energy <= 0 " " (ticks mod 20) = 0 " " (ticks mod 250) = 0 " " true "]
end

to create-agents
  crt number-of-agents [
    choose-action-condition-random
    set energy 0
    set previous-tick-energy 0
    set cheated false
    set cheating-profitable false
    ifelse cheated = false [set color green][set color red]
  ]
  ; implements the network that defines the agents' neighborhood

  ; 1. random network of grade 2 * number of links
  if network = "random" [
    ask turtles [create-links-with n-of number-of-links other turtles with [link-with myself = nobody]]
  ]
  ; 2. small-world network
  if network = "small-world" [
    let max-who 1 + max [who] of turtles
    let sorted sort ([who] of turtles)
    foreach sorted [ ?1 ->
      ask turtle ?1 [
        let i 1
        repeat number-of-links [
          create-link-with turtle ((?1 + i) mod max-who)
          set i i + 1
        ]
      ]
    ]
    repeat round (rewire-prop * number-of-agents) [
      ask one-of turtles [
        ask one-of my-links [die]
        create-link-with one-of other turtles with [link-with myself = nobody]
      ]
    ]
  ]
  if display-network? [
    layout-circle (sort turtles) (max-pxcor - 1)
    display
  ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;end setup functions;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


to go

    if resource = 0 or (((count turtles with [energy < average-energy] / number-of-agents) > agentStatusEndThreshold ) AND selectedInstitution != ["" ""] AND ticks > 5000) or ticks > 6000 [
    stop
  ]
  if ticks mod InstitutionalEmergenceInterval = 0 AND ticks >= InstitutionalEmergenceStart
  [
    if institution? [
      ; the change of institution does not only happen if the threshold is reached, but also if the time is right for institutional change. so it happens in intervals.
      if (count turtles with [energy < 0] / number-of-agents) > threshold-institutional-change
      [set institution-changed-time ticks
        establish-institution]

    ]
    ask turtles [
      set energy 0
      set cheated false
    ]
  ]
  ifelse selectedInstitution = ["" ""]
  [
    run-selected-action
  ]
  [
    run-institutional-action
    ; we assume that whenever an institutional action is present, there is also monitoring
    set rule-compliance (count turtles with [cheated = false]) / number-of-agents ; we have to do this per tick just befor each monitoring and sanctioning.
    monitor-agents;
  ]
if external-shock  = 1 [
   ; print ticks mod Shock-interval
    if (ticks mod Shock-interval) = 0 [
     ; print "shock happening"
   introduce-shock
    ]
  ]
  grow-resource
  if selectedInstitution != ["" ""] [set institution-time institution-time + 1]; are we keeping track of the period where there is an institution selected?



    if ticks > start-record-time [compute-indicators]
  tick
end

to grow-resource
  ifelse resource-type = "fishery"
  [
    ; logistic growth of the resource
    set resource resource + r * resource * (1 - resource / K)
  ]
  [
    ; fixed amount added per year up to the maximum
    set resource resource + r  * (K / 5)
    if resource > K [
      set resource K
    ]
  ]

end

to introduce-shock

  if ticks > 1 [

    set resource  resource - (resource * (resource-loss-percentage / 100))

   set shock-time ticks
    ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;agents running their own strategies without an institution;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
to run-selected-action
  set consumed-resource 0
  set willingess-to-consume 0

  ask turtles[


    if (ticks > 0) AND (ticks > social-shock-time) AND (social-shock = 1) [set energy energy - taxation-amount ]

    if ticks > 0 [set energy energy - energy-consumption ]

    ifelse energy < 0;  he is making a loss doing the current action-condition combination, therefore he changes his routine
    [
      choose-new-own-strategy ;

      run (word "if" selected-condition "[" selected-action " true ]" ) ; running the new action-condition combination
    ]
    [ ; current action profitable, continue
      run (word "if" selected-condition "[" selected-action " true ]" )
    ]
    set previous-tick-energy energy
  ]
end

to choose-new-own-strategy
  ;;there is a probability of either going for a random action again, or doing what the most successful guy in his neighbourhood is doing
  ifelse random-float 1 < innovationRate
  [
    choose-action-condition-random
    set own-idea-fine random max-fine + 1
    set own-idea-monitoring-intensity random max-monitoring-intensity-percentage + 1
  ]
  [
    choose-best-neighbour-action-condition
  ]
end

to choose-action-condition-random ;this method is also used in other parts of the code
  set selected-action one-of actionList
  set selected-condition one-of conditionList
end

to choose-best-neighbour-action-condition
  ; do the same as before, but it is more efficient
  let target max-one-of link-neighbors [previous-tick-energy]
  set selected-action [selected-action] of target
  set selected-condition [selected-condition] of target
  set own-idea-fine [own-idea-fine] of target
  set own-idea-monitoring-intensity [own-idea-monitoring-intensity] of target
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;agents executing institutional actions;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to  establish-institution

 ; let old-institution selectedInstitution ; sometimes the old institution is reselected, so we want to make sure the new institution is different
  let modal-combination item 0 modes [(word selected-action "@" selected-condition  )] of turtles
  let part1 substring modal-combination 0 (position "@" modal-combination)
  let part2 substring modal-combination (position "@" modal-combination + 1) (length modal-combination - 1)
  set selectedAction  part1; we want to print the instituion in different columns for the sake of better analysis
  set selectedCondition part2;
  set selectedInstitution (list part1 part2)
  output-print (word "Tick n. " ticks "; Institution: " selectedInstitution)



  set institution-time 1

  select-common-fine-monitoring
end

to select-common-fine-monitoring
  set monitoring-intensity-percentage one-of modes [own-idea-monitoring-intensity] of turtles
  set fine one-of modes [own-idea-fine] of turtles
end

to run-institutional-action
  set consumed-resource 0
  set willingess-to-consume 0
  ask turtles[
     if (ticks > 0) AND (ticks > social-shock-time) AND (social-shock = 1) [set energy energy - taxation-amount ] ; social shock happening
    if ticks > 0 [set energy energy - energy-consumption]
    if energy < 0 [
      choose-new-own-strategy ;code above
    ];  he is making a loss doing the current action-condition combination, therefore he changes his routine
    calculate-utility
    ifelse cheating-profitable = true
      [
        run (word "if" selected-condition "[" selected-action " true ]" )
        set cheated true
        ; print "cheating"
      ]
      [run (word "if" item 1 selectedInstitution "[" item 0 selectedInstitution " true ]") ; doesn't cheat
        set cheated false
      ]
    set previous-tick-energy energy
    if display-network? = true [
      ifelse cheated = false [set color green][set color red]
      display
    ]
  ]
end

to calculate-utility
  let potential-energy-own-strategy 0
  let potential-energy-institution 0
  let originial-energy energy ; save this energy to return the values back to original after calculation
  ; cheating depends on the individual-cheating-propension and on the proportion of cheaters in the agent link-neighborhood
  ; the relative weight of the two variables depends on the social-influence parameter

  ifelse random-float 1 < (individual-cheating-propension * (1 - social-influence) + (count link-neighbors with [cheated = true] / count link-neighbors) * social-influence)
  [
    run (word "if" selected-condition "[" selected-action " false ]" )
    set potential-energy-own-strategy energy
    set energy originial-energy ; return the energy level back to what it was because this is just utility calculation

    run (word "if" item 1 selectedInstitution "[" item 0 selectedInstitution " false ]")
    set potential-energy-institution  energy
    set energy originial-energy ; return the energy level back to what it was because this is just utility calculation

    ifelse potential-energy-own-strategy > potential-energy-institution
    [
      set cheating-profitable true

    ]
    [
      set cheating-profitable false

    ]
  ]
  [
    set cheating-profitable false

  ]
end

to monitor-agents


  set monitoring-cost monitoring-cost-weight * monitoring-intensity-percentage ;the monitoring cost should be a model parameter multiplied by the monitoring intensity, which instead is chosen by the agents.
                                                                               ;This way agents will have to balance the costs of doing extra monitoring against the level of fines.
 let number-cheaters 0
  set total-fine 0; we only sum up the fines that have been given in this round
  set rule-compliance (count turtles with [cheating-profitable = false]) / number-of-agents ; compute the proportion of agents who cheated

  let monitor-number (monitoring-intensity-percentage * number-of-agents) / 100
  ask n-of (monitor-number) turtles [
    if cheated = true [
      set number-cheaters number-cheaters + 1
      set energy energy - fine
      set cheated  false
      set total-fine total-fine + fine
    ]
  ]
  let energy-balance monitoring-cost - total-fine ;The actual monitoring cost that the agent has to pay, we assume that some of the costs are taken from the fines that the agents have paid
                                           ;This way only the cost after the fines have been subtracted are paid by the agents. Note also that, in case the fines exceed the monitoring costs, agents may receive some extra-energy.
  ;everybody has to pay for the monitoring costs

 if number-cheaters / number-of-agents > cheating-propension [
   set cheating-propension number-cheaters / number-of-agents
 ]
  ask turtles[
    set energy energy - (energy-balance / number-of-agents) ; to cover the monitoring costs, this is relative to monitoring intensity selected by agents, as well as the fine which is also selected by agents
  ]

end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;basic functions;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

to eat [x real-action] ; changed in order not to consume resource when agents do the ficitious play
  ifelse x <= 0
  [
    set energy energy + x * resource-energy-ratio
  ]
  [
    ; we want to see how much they would like to consume in total per tick and how much they actually do, according to the availablility of resource: consumed-resource
    if real-action = true [set willingess-to-consume willingess-to-consume + x]

    ; in this case agents cannot destroy completely the resource
    if resource >= x
    [
      set energy energy + x * resource-energy-ratio
      if real-action = true [
        set resource resource - x
        set consumed-resource consumed-resource + x
      ]
    ]


  ]
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;data analysis;;;;;;;;;;;;;;;;;;;;;;;;;

to compute-indicators
  set average-energy ((mean [energy] of turtles) + (ticks - (start-record-time + 1)) * average-energy) / (ticks - start-record-time)
  set average-resource (resource + (ticks - (start-record-time + 1)) * average-resource) / (ticks - start-record-time)
  set av-rule-compliance (rule-compliance + (ticks - (start-record-time + 1)) * av-rule-compliance) / (ticks - start-record-time)
  set av-monitoring-percentage (monitoring-intensity-percentage + (ticks - (start-record-time + 1)) * av-monitoring-percentage) / (ticks - start-record-time)
  set av-fine (fine + (ticks - (start-record-time + 1)) * av-fine) / (ticks - start-record-time)
end
@#$#@#$#@
GRAPHICS-WINDOW
765
10
1130
376
-1
-1
7.0
1
10
1
1
1
0
0
0
1
-25
25
-25
25
1
1
1
ticks
30.0

BUTTON
355
140
428
173
NIL
setup
NIL
1
T
OBSERVER
NIL
NIL
NIL
NIL
1

BUTTON
440
140
503
173
NIL
go
T
1
T
OBSERVER
NIL
NIL
NIL
NIL
0

SLIDER
20
40
202
73
number-of-agents
number-of-agents
0
250
100.0
10
1
NIL
HORIZONTAL

SLIDER
390
205
562
238
K
K
0
50000
14652.0
500
1
NIL
HORIZONTAL

SLIDER
390
245
562
278
r
r
0
1
0.2663474961267776
0.01
1
NIL
HORIZONTAL

SWITCH
389
44
561
77
display-network?
display-network?
1
1
-1000

SLIDER
424
84
596
117
number-of-links
number-of-links
0
5
4.0
1
1
NIL
HORIZONTAL

SLIDER
20
80
222
113
energy-consumption
energy-consumption
0
10
1.0
1
1
NIL
HORIZONTAL

SLIDER
20
120
192
153
innovationRate
innovationRate
0
0.5
0.13879068522940258
0.05
1
NIL
HORIZONTAL

PLOT
15
630
305
825
Resource
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot resource"

PLOT
15
425
305
625
Average consumed resource
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot consumed-resource / number-of-agents"

PLOT
310
630
600
825
mean energy of agents
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot mean [energy] of turtles"

PLOT
310
425
600
625
Average willingness to consume
NIL
NIL
0.0
10.0
0.0
10.0
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot willingess-to-consume / number-of-agents"

CHOOSER
244
34
382
79
network
network
"random" "small-world"
0

SLIDER
244
84
416
117
rewire-prop
rewire-prop
0
0.2
0.1
0.01
1
NIL
HORIZONTAL

TEXTBOX
244
9
394
27
Network parameters
14
0.0
1

TEXTBOX
410
185
580
203
Resource parameters
14
0.0
1

TEXTBOX
20
10
170
28
Agent parameters
14
0.0
1

TEXTBOX
23
180
188
200
Institution parameters
14
0.0
1

SWITCH
18
302
150
335
Institution?
Institution?
0
1
-1000

OUTPUT
750
10
1205
405
12

SLIDER
16
253
273
286
InstitutionalEmergenceTime
InstitutionalEmergenceTime
1
1000
1000.0
1
1
NIL
HORIZONTAL

MONITOR
1155
465
1293
530
NIL
average-energy
1
1
16

MONITOR
1313
466
1465
531
NIL
average-resource
0
1
16

SLIDER
220
300
472
333
max-monitoring-intensity-percentage
max-monitoring-intensity-percentage
0
100
100.0
1
1
NIL
HORIZONTAL

SLIDER
525
300
697
333
max-fine
max-fine
0
20
20.0
1
1
NIL
HORIZONTAL

SLIDER
30
360
312
393
individual-cheating-propension
individual-cheating-propension
0
0.2
0.11942314587765801
0.01
1
NIL
HORIZONTAL

PLOT
630
425
1110
815
Rule compliance
NIL
NIL
0.0
10.0
0.0
0.1
true
false
"" ""
PENS
"default" 1.0 0 -16777216 true "" "plot rule-compliance"

SLIDER
335
360
507
393
social-influence
social-influence
0
1
0.9608371738570617
0.1
1
NIL
HORIZONTAL

MONITOR
1155
550
1337
607
NIL
av-rule-compliance
3
1
14

MONITOR
1155
625
1307
682
NIL
av-institution-time
0
1
14

MONITOR
1155
700
1372
757
NIL
av-monitoring-percentage
1
1
14

MONITOR
1415
700
1477
757
NIL
av-fine
1
1
14

SLIDER
532
360
732
393
monitoring-cost-weight
monitoring-cost-weight
0
100
56.0
1
1
NIL
HORIZONTAL

CHOOSER
595
25
733
70
resource-type
resource-type
"fishery" "irrigation"
0

SLIDER
25
205
237
238
threshold-institutional-change
threshold-institutional-change
0
1
0.660715312395219
0.05
1
NIL
HORIZONTAL

MONITOR
1365
555
1517
600
NIL
cheating-propension
17
1
11

MONITOR
1290
780
1442
825
NIL
resource-loss-percentage
17
1
11

MONITOR
1355
280
1442
325
NIL
shock-interval
17
1
11

MONITOR
1210
230
1282
275
NIL
shock-time
17
1
11

MONITOR
1230
335
1325
380
NIL
external-shock
17
1
11

MONITOR
1395
395
1487
440
NIL
institution-time
17
1
11

MONITOR
1300
164
1454
209
NIL
agentStatusEndThreshold
17
1
11

@#$#@#$#@
## WHAT IS IT?

(a general understanding of what the model is trying to show or explain)

## HOW IT WORKS

(what rules the agents use to create the overall behavior of the model)

## HOW TO USE IT

(how to use the model, including a description of each of the items in the Interface tab)

## THINGS TO NOTICE

(suggested things for the user to notice while running the model)

## THINGS TO TRY

(suggested things for the user to try to do (move sliders, switches, etc.) with the model)

## EXTENDING THE MODEL

(suggested things to add or change in the Code tab to make the model more complicated, detailed, accurate, etc.)

## NETLOGO FEATURES

(interesting or unusual features of NetLogo that the model uses, particularly in the Code tab; or where workarounds were needed for missing features)

## RELATED MODELS

(models in the NetLogo Models Library and elsewhere which are of related interest)

## CREDITS AND REFERENCES

(a reference to the model's URL on the web if it has one, as well as any other necessary credits, citations, and links)
@#$#@#$#@
default
true
0
Polygon -7500403 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7500403 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7500403 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7500403 true true 150 285 285 225 285 75 150 135
Polygon -7500403 true true 150 135 15 75 150 15 285 75
Polygon -7500403 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7500403 true true 96 182 108
Circle -7500403 true true 110 127 80
Circle -7500403 true true 110 75 80
Line -7500403 true 150 100 80 30
Line -7500403 true 150 100 220 30

butterfly
true
0
Polygon -7500403 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7500403 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7500403 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7500403 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7500403 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7500403 true true 47 195 58
Circle -7500403 true true 195 195 58

circle
false
0
Circle -7500403 true true 0 0 300

circle 2
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240

cow
false
0
Polygon -7500403 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7500403 true true 73 210 86 251 62 249 48 208
Polygon -7500403 true true 25 114 16 195 9 204 23 213 25 200 39 123

cylinder
false
0
Circle -7500403 true true 0 0 300

dot
false
0
Circle -7500403 true true 90 90 120

face happy
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7500403 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7500403 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7500403 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7500403 true true 60 15 75 300
Polygon -7500403 true true 90 150 270 90 90 30
Line -7500403 true 75 135 90 135
Line -7500403 true 75 45 90 45

flower
false
0
Polygon -10899396 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7500403 true true 85 132 38
Circle -7500403 true true 130 147 38
Circle -7500403 true true 192 85 38
Circle -7500403 true true 85 40 38
Circle -7500403 true true 177 40 38
Circle -7500403 true true 177 132 38
Circle -7500403 true true 70 85 38
Circle -7500403 true true 130 25 38
Circle -7500403 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -10899396 true false 189 233 219 188 249 173 279 188 234 218
Polygon -10899396 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7500403 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7500403 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7500403 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7500403 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7500403 true 150 0 150 300

line half
true
0
Line -7500403 true 150 0 150 150

pentagon
false
0
Polygon -7500403 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7500403 true true 110 5 80
Polygon -7500403 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7500403 true true 127 79 172 94
Polygon -7500403 true true 195 90 240 150 225 180 165 105
Polygon -7500403 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7500403 true true 135 90 165 300
Polygon -7500403 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7500403 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7500403 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7500403 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7500403 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7500403 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7500403 true true 135 90 120 45 150 15 180 45 165 90

sheep
false
15
Circle -1 true true 203 65 88
Circle -1 true true 70 65 162
Circle -1 true true 150 105 120
Polygon -7500403 true false 218 120 240 165 255 165 278 120
Circle -7500403 true false 214 72 67
Rectangle -1 true true 164 223 179 298
Polygon -1 true true 45 285 30 285 30 240 15 195 45 210
Circle -1 true true 3 83 150
Rectangle -1 true true 65 221 80 296
Polygon -1 true true 195 285 210 285 210 240 240 210 195 210
Polygon -7500403 true false 276 85 285 105 302 99 294 83
Polygon -7500403 true false 219 85 210 105 193 99 201 83

square
false
0
Rectangle -7500403 true true 30 30 270 270

square 2
false
0
Rectangle -7500403 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7500403 true true 151 1 185 108 298 108 207 175 242 282 151 216 59 282 94 175 3 108 116 108

target
false
0
Circle -7500403 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7500403 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7500403 true true 120 120 60

tree
false
0
Circle -7500403 true true 118 3 94
Rectangle -6459832 true false 120 195 180 300
Circle -7500403 true true 65 21 108
Circle -7500403 true true 116 41 127
Circle -7500403 true true 45 90 120
Circle -7500403 true true 104 74 152

triangle
false
0
Polygon -7500403 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7500403 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7500403 true true 4 45 195 187
Polygon -7500403 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7500403 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7500403 false true 24 174 42
Circle -7500403 false true 144 174 42
Circle -7500403 false true 234 174 42

turtle
true
0
Polygon -10899396 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -10899396 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -10899396 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -10899396 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -10899396 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7500403 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7500403 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7500403 true 150 285 150 15
Line -7500403 true 15 150 285 150
Circle -7500403 true true 120 120 60
Line -7500403 true 216 40 79 269
Line -7500403 true 40 84 269 221
Line -7500403 true 40 216 269 79
Line -7500403 true 84 40 221 269

wolf
false
0
Polygon -16777216 true false 253 133 245 131 245 133
Polygon -7500403 true true 2 194 13 197 30 191 38 193 38 205 20 226 20 257 27 265 38 266 40 260 31 253 31 230 60 206 68 198 75 209 66 228 65 243 82 261 84 268 100 267 103 261 77 239 79 231 100 207 98 196 119 201 143 202 160 195 166 210 172 213 173 238 167 251 160 248 154 265 169 264 178 247 186 240 198 260 200 271 217 271 219 262 207 258 195 230 192 198 210 184 227 164 242 144 259 145 284 151 277 141 293 140 299 134 297 127 273 119 270 105
Polygon -7500403 true true -1 195 14 180 36 166 40 153 53 140 82 131 134 133 159 126 188 115 227 108 236 102 238 98 268 86 269 92 281 87 269 103 269 113

x
false
0
Polygon -7500403 true true 270 75 225 30 30 225 75 270
Polygon -7500403 true true 30 75 75 30 270 225 225 270
@#$#@#$#@
NetLogo 6.0.4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
<experiments>
  <experiment name="experiment__socialShock_dynaicEnd" repetitions="500" runMetricsEveryStep="true">
    <setup>setup</setup>
    <go>go</go>
    <metric>institutionalEmergenceStart</metric>
    <metric>threshold-institutional-change</metric>
    <metric>selectedAction</metric>
    <metric>selectedCondition</metric>
    <metric>institution-changed-time</metric>
    <metric>monitoring-intensity-percentage</metric>
    <metric>fine</metric>
    <metric>institution-time</metric>
    <metric>social-shock-time</metric>
    <metric>taxation-amount</metric>
    <metric>agentStatusEndThreshold</metric>
  </experiment>
</experiments>
@#$#@#$#@
@#$#@#$#@
default
0.0
-0.2 0 0.0 1.0
0.0 1 1.0 0.0
0.2 0 0.0 1.0
link direction
true
0
Line -7500403 true 150 150 90 180
Line -7500403 true 150 150 210 180
@#$#@#$#@
1
@#$#@#$#@
